/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.function.Function;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.event.client.RenderOverrideEvent;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BladeRenderState
extends RenderStateShard {
    private static final Color defaultColor;
    private static Color col;
    public static final int MAX_LIGHT = 0xF000E0;
    public static final VertexFormat POSITION_TEX;
    public static final RenderType BLADE_GLINT;
    protected static final RenderStateShard.TransparencyStateShard LIGHTNING_ADDITIVE_TRANSPARENCY;
    protected static final RenderStateShard.TransparencyStateShard LIGHTNING_REVERSE_TRANSPARENCY;

    public static void setCol(int rgba) {
        BladeRenderState.setCol(rgba, true);
    }

    public static void setCol(int rgb, boolean hasAlpha) {
        BladeRenderState.setCol(new Color(rgb, hasAlpha));
    }

    public static void setCol(Color value) {
        col = value;
    }

    public static void resetCol() {
        col = defaultColor;
    }

    public BladeRenderState(String p_i225973_1_, Runnable p_i225973_2_, Runnable p_i225973_3_) {
        super(p_i225973_1_, p_i225973_2_, p_i225973_3_);
    }

    public static void renderOverrided(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, Util.m_143827_(BladeRenderState::getSlashBladeBlend), true);
    }

    public static void renderOverridedColorWrite(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, Util.m_143827_(BladeRenderState::getSlashBladeBlendColorWrite), true);
    }

    public static void renderChargeEffect(ItemStack stack, float f, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, loc -> BladeRenderState.getChargeEffect(loc, f * 0.1f % 1.0f, f * 0.01f % 1.0f), false);
    }

    public static void renderOverridedLuminous(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, Util.m_143827_(BladeRenderState::getSlashBladeBlendLuminous), false);
    }

    public static void renderOverridedLuminousDepthWrite(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, Util.m_143827_(BladeRenderState::getSlashBladeBlendLuminousDepthWrite), false);
    }

    public static void renderOverridedReverseLuminous(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BladeRenderState.renderOverrided(stack, model, target, texture, matrixStackIn, bufferIn, packedLightIn, Util.m_143827_(BladeRenderState::getSlashBladeBlendReverseLuminous), false);
    }

    public static void renderOverrided(ItemStack stack, WavefrontObject model, String target, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Function<ResourceLocation, RenderType> getRenderType, boolean enableEffect) {
        RenderOverrideEvent event = RenderOverrideEvent.onRenderOverride(stack, model, target, texture, matrixStackIn, bufferIn);
        if (event.isCanceled()) {
            return;
        }
        ResourceLocation loc = event.getTexture();
        RenderType rt = getRenderType.apply(loc);
        VertexConsumer vb = bufferIn.m_6299_(rt);
        Face.setCol(col);
        Face.setLightMap(packedLightIn);
        Face.setMatrix(matrixStackIn);
        event.getModel().tessellateOnly(vb, event.getTarget());
        if (stack.m_41790_() && enableEffect) {
            vb = bufferIn.m_6299_(BladeRenderState.getSlashBladeGlint());
            event.getModel().tessellateOnly(vb, event.getTarget());
        }
        Face.resetMatrix();
        Face.resetLightMap();
        Face.resetCol();
        Face.resetAlphaOverride();
        Face.resetUvOperator();
        BladeRenderState.resetCol();
    }

    public static VertexConsumer getBuffer(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean glintIn) {
        return null;
    }

    public static RenderType getSlashBladeBlend(ResourceLocation p_228638_0_) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173113_).m_110675_(RenderStateShard.f_110129_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_228638_0_, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110669_(RenderStateShard.f_110118_).m_110687_(RenderStateShard.f_110114_).m_110691_(true);
        return RenderType.m_173215_((String)"slashblade_blend", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeGlint() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173083_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ItemRenderer.f_273897_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110675_(f_110129_).m_110683_(f_110151_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_glint", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeBlendColorWrite(ResourceLocation p_228638_0_) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173113_).m_110675_(RenderStateShard.f_110126_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_228638_0_, false, true)).m_110685_(RenderStateShard.f_110139_).m_110671_(f_110152_).m_110687_(f_110115_).m_110669_(RenderStateShard.f_110118_).m_110691_(true);
        return RenderType.m_173215_((String)"slashblade_blend_write_color", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeBlendLuminous(ResourceLocation p_228638_0_) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_234323_).m_110675_(f_110129_).m_110661_(RenderStateShard.f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_228638_0_, true, true)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110687_(f_110115_).m_110669_(RenderStateShard.f_110118_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_blend_luminous", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getChargeEffect(ResourceLocation p_228638_0_, float x, float y) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173074_).m_110675_(f_110129_).m_110661_(RenderStateShard.f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_228638_0_, false, true)).m_110683_((RenderStateShard.TexturingStateShard)new RenderStateShard.OffsetTexturingStateShard(x, y)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110687_(RenderStateShard.f_110115_).m_110669_(RenderStateShard.f_110118_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_charge_effect", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeBlendLuminousDepthWrite(ResourceLocation p_228638_0_) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_110675_(RenderStateShard.f_110126_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_228638_0_, true, true)).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110669_(RenderStateShard.f_110118_).m_110687_(f_110114_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_blend_luminous_depth_write", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    public static RenderType getSlashBladeBlendReverseLuminous(ResourceLocation p_228638_0_) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_110675_(RenderStateShard.f_110126_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_228638_0_, true, true)).m_110685_(LIGHTNING_REVERSE_TRANSPARENCY).m_110671_(RenderStateShard.f_110152_).m_110687_(f_110115_).m_110669_(RenderStateShard.f_110118_).m_110691_(false);
        return RenderType.m_173215_((String)"slashblade_blend_reverse_luminous", (VertexFormat)WavefrontObject.POSITION_TEX_LMAP_COL_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    }

    static {
        col = defaultColor = Color.white;
        POSITION_TEX = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"UV0", (Object)DefaultVertexFormat.f_85806_).build());
        BLADE_GLINT = RenderType.m_173215_((String)"blade_glint", (VertexFormat)POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173083_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ItemRenderer.f_273833_, true, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false));
        LIGHTNING_ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        LIGHTNING_REVERSE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.blendEquation((int)32779);
        }, () -> {
            RenderSystem.blendEquation((int)32774);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }
}

